<?php $__env->startSection('title', 'Tambah Pengguna'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2>Tambah Pengguna</h2>
</div>

<div class="card" style="max-width:700px">
    <form method="post" action="<?php echo e(route('admin.users.store')); ?>">
        <?php echo csrf_field(); ?>
        
        <h3 style="margin-bottom:16px;color:#374151">Informasi Dasar</h3>
        <label>ID Card / Employee ID *<input type="text" name="employee_id" value="<?php echo e(old('employee_id')); ?>" placeholder="EMP001" required></label>
        <label>Nama *<input type="text" name="name" value="<?php echo e(old('name')); ?>" required></label>
        <label>Email *<input type="email" name="email" value="<?php echo e(old('email')); ?>" required></label>
        <label>Password *<input type="password" name="password" required></label>
        
        <hr style="margin:24px 0;border:none;border-top:1px solid #e5e7eb">
        
        <h3 style="margin-bottom:16px;color:#374151">Informasi Pribadi</h3>
        <label>Telepon<input type="text" name="phone" value="<?php echo e(old('phone')); ?>" placeholder="08123456789"></label>
        <label>Alamat<textarea name="address" rows="3" placeholder="Alamat lengkap"><?php echo e(old('address')); ?></textarea></label>
        <label>Tanggal Lahir<input type="date" name="birth_date" value="<?php echo e(old('birth_date')); ?>"></label>
        
        <hr style="margin:24px 0;border:none;border-top:1px solid #e5e7eb">
        
        <h3 style="margin-bottom:16px;color:#374151">Role & Shift</h3>
        <label>Roles (tahan Ctrl untuk pilih multiple)
            <select name="roles[]" multiple size="5">
                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($role->id); ?>"><?php echo e($role->name); ?> - <?php echo e($role->description); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </label>
        
        <label>Shift (tahan Ctrl untuk pilih multiple)
            <select name="shifts[]" multiple size="5">
                <?php $__currentLoopData = $shifts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($shift->id); ?>"><?php echo e($shift->name); ?> (<?php echo e($shift->start_time); ?> - <?php echo e($shift->end_time); ?>)</option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </label>
        
        <div style="margin-top:20px;display:flex;gap:8px">
            <button type="submit" class="btn btn-primary">💾 Simpan</button>
            <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/proa8625/public_html/absensi.prodental.my.id/resources/views/admin/users/create.blade.php ENDPATH**/ ?>