<?php $__env->startSection('title', 'Riwayat Absensi'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2>Riwayat Absensi</h2>
</div>


<div class="card" style="margin-bottom:8px;padding:12px;background:#f0f9ff;border-left:4px solid #0ea5e9">
    <p style="margin:0;font-size:13px;color:#0c4a6e">
        💡 <strong>Info Absensi:</strong>
        Periode <?php echo e(request('period', 'week')); ?> |
        Total Hadir: <?php echo e($stats['present_days']); ?> hari |
        Terlambat: <?php echo e($stats['late_days']); ?> |
        Total Jam: <?php echo e(number_format($stats['total_hours'], 2)); ?> jam
    </p>
</div>


<div class="card" style="margin-bottom:16px">
    <form method="get" style="display:flex;gap:8px;align-items:center">
        <select name="period" style="margin:0">
            <option value="week" <?php echo e(request('period') == 'week' ? 'selected' : ''); ?>>Minggu Ini</option>
            <option value="month" <?php echo e(request('period') == 'month' ? 'selected' : ''); ?>>Bulan Ini</option>
            <option value="custom" <?php echo e(request('period') == 'custom' ? 'selected' : ''); ?>>Custom</option>
        </select>

        <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>">
        <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>">

        <select name="status">
            <option value="">Semua Status</option>
            <option value="present" <?php echo e(request('status') == 'present' ? 'selected' : ''); ?>>Hadir</option>
            <option value="late" <?php echo e(request('status') == 'late' ? 'selected' : ''); ?>>Terlambat</option>
            <option value="absent" <?php echo e(request('status') == 'absent' ? 'selected' : ''); ?>>Tidak Hadir</option>
        </select>

        <button class="btn btn-secondary" type="submit">🔍 Filter</button>
        
    </form>
</div>

<div style="overflow-x:auto">
<table>
    <thead>
        <tr>
            <th>Tanggal</th>
            <th>Nama</th>
            <th>Status</th>
            <th>Check In</th>
            <th>Check Out</th>
            <th style="text-align:center">Jam Kerja</th>
            <th>Lokasi Masuk</th>
            <th>Lokasi Keluar</th>
            <th>Dokumen</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td><?php echo e($attendance->date->format('d/m/Y')); ?></td>

            <td>
                <strong><?php echo e($attendance->user->name ?? '-'); ?></strong>
                <div style="font-size:12px;color:#6b7280">
                    <?php echo e($attendance->user->email ?? ''); ?>

                </div>
            </td>

            <td>
                <?php
                    $statusStyle = match($attendance->status) {
                        'present' => 'background:#d1fae5;color:#065f46',
                        'late' => 'background:#fef3c7;color:#92400e',
                        'absent' => 'background:#fee2e2;color:#991b1b',
                        default => 'background:#e5e7eb;color:#374151'
                    };
                ?>
                <span style="font-size:12px;padding:4px 8px;border-radius:6px;<?php echo e($statusStyle); ?>">
                    <?php echo e(strtoupper($attendance->status)); ?>

                </span>
            </td>

            <td><?php echo e($attendance->check_in ?? '-'); ?></td>
            <td><?php echo e($attendance->check_out ?? '-'); ?></td>

            <td style="text-align:center">
                <span style="font-weight:600;color:#2563eb">
                    <?php echo e(number_format($attendance->work_hours ?? 0, 2)); ?> jam
                </span>
            </td>

            <td><?php echo e($attendance->check_in_location ?? '-'); ?></td>
            <td><?php echo e($attendance->check_out_location ?? '-'); ?></td>

            <td>
                <?php if($attendance->hasDocument()): ?>
                    <a href="<?php echo e($attendance->getDocumentUrl()); ?>" target="_blank"
                       class="btn btn-secondary" style="padding:4px 8px;font-size:12px">
                        📎 Lihat
                    </a>
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
            <td colspan="9" style="text-align:center;color:#9ca3af">
                Tidak ada data absensi
            </td>
        </tr>
        <?php endif; ?>
    </tbody>
</table>
</div>

<div class="pagination">
    <?php echo e($attendances->withQueryString()->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/proa8625/public_html/absensi.prodental.my.id/resources/views/admin/attendance/riwayat.blade.php ENDPATH**/ ?>