<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#1ec7e6">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <title>Detail Keluhan - Sistem Absensi</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }
        
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            width: 100%;
            max-width: 393px;
            min-height: 100vh;
            margin: 0 auto;
            overflow-y: auto;
        }
        
        .header {
            background: linear-gradient(135deg, #1ec7e6, #0ea5e9);
            color: white;
            padding: 20px;
            display: flex;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .back-btn {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: none;
            padding: 10px;
            border-radius: 50%;
            font-size: 18px;
            cursor: pointer;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 16px;
            text-decoration: none;
        }

        .header-title {
            font-size: 18px;
            font-weight: 600;
        }

        .content {
            padding: 20px;
        }

        .detail-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
            margin-bottom: 20px;
        }

        .detail-section {
            margin-bottom: 20px;
            padding-bottom: 20px;
            border-bottom: 1px solid #e5e7eb;
        }

        .detail-section:last-child {
            border-bottom: none;
            margin-bottom: 0;
        }

        .detail-label {
            font-size: 12px;
            color: #6b7280;
            margin-bottom: 6px;
            font-weight: 600;
        }

        .detail-value {
            font-size: 14px;
            color: #374151;
        }

        .detail-title {
            font-size: 15px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 8px;
        }

        .detail-description {
            font-size: 14px;
            color: #374151;
            line-height: 1.6;
            white-space: pre-wrap;
        }

        .status-badge {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }

        .status-badge.pending {
            background: #fef3c7;
            color: #d97706;
        }

        .status-badge.process {
            background: #dbeafe;
            color: #2563eb;
        }

        .status-badge.done {
            background: #d1fae5;
            color: #059669;
        }

        .priority-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            display: inline-block;
            vertical-align: middle;
            margin-right: 6px;
        }

        .priority-dot.low { background: #10b981; }
        .priority-dot.medium { background: #f59e0b; }
        .priority-dot.high { background: #ef4444; }

        .attachment-link {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            color: #3b82f6;
            text-decoration: none;
            font-size: 14px;
        }

        .attachment-link:hover {
            text-decoration: underline;
        }

        .response-section {
            background: #f8fafc;
            padding: 15px;
            border-radius: 8px;
            margin-top: 10px;
        }

        .response-label {
            font-size: 12px;
            color: #6b7280;
            margin-bottom: 6px;
            font-weight: 600;
        }

        .response-value {
            font-size: 14px;
            color: #374151;
            line-height: 1.6;
        }
    </style>
</head>
<body>
    <div class="header">
        <a href="{{ route('complaints.history') }}" class="back-btn">←</a>
        <div class="header-title">Detail Keluhan</div>
    </div>

    <div class="content">
        <div class="detail-card">
            <div class="detail-section">
                <div class="detail-label">Nomor Tiket</div>
                <div class="detail-value" style="font-family: monospace; font-weight: 600;">
                    {{ $complaint['ticketNumber'] }}
                </div>
            </div>
            
            <div class="detail-section">
                <div class="detail-label">Status</div>
                <div class="detail-value">
                    @php
                        $statusText = [
                            'pending' => 'Menunggu',
                            'process' => 'Diproses',
                            'done' => 'Selesai',
                        ];
                    @endphp
                    <span class="status-badge {{ $complaint['status'] }}">
                        {{ $statusText[$complaint['status']] ?? $complaint['status'] }}
                    </span>
                </div>
            </div>
            
            <div class="detail-section">
                <div class="detail-label">Kategori</div>
                <div class="detail-value">
                    @php
                        $categoryText = [
                            'hardware' => 'Hardware/Perangkat',
                            'software' => 'Software/Aplikasi',
                            'network' => 'Jaringan/Internet',
                            'system' => 'Sistem Absensi',
                            'access' => 'Akses/Login',
                            'general' => 'Umum',
                            'other' => 'Lainnya',
                        ];
                    @endphp
                    {{ $categoryText[$complaint['category']] ?? $complaint['category'] }}
                </div>
            </div>
            
            <div class="detail-section">
                <div class="detail-label">Judul</div>
                <div class="detail-title">{{ $complaint['title'] }}</div>
            </div>
            
            <div class="detail-section">
                <div class="detail-label">Deskripsi</div>
                <div class="detail-description">{{ $complaint['description'] }}</div>
            </div>
            
            <div class="detail-section">
                <div class="detail-label">Urgensi</div>
                <div class="detail-value">
                    @php
                        $priorityText = [
                            'low' => 'Rendah',
                            'medium' => 'Sedang',
                            'high' => 'Tinggi',
                        ];
                    @endphp
                    <span class="priority-dot {{ $complaint['priority'] }}"></span>
                    {{ $priorityText[$complaint['priority']] ?? $complaint['priority'] }}
                </div>
            </div>
            
            @if($complaint['location'])
                <div class="detail-section">
                    <div class="detail-label">Lokasi</div>
                    <div class="detail-value">{{ $complaint['location'] }}</div>
                </div>
            @endif
            
            @if($complaint['attachment'])
                <div class="detail-section">
                    <div class="detail-label">Lampiran</div>
                    <div class="detail-value">
                        <a href="{{ Storage::url($complaint['attachment']) }}" 
                           target="_blank" 
                           class="attachment-link">
                            📎 Lihat Lampiran
                        </a>
                    </div>
                </div>
            @endif
            
            <div class="detail-section">
                <div class="detail-label">Tanggal Laporan</div>
                <div class="detail-value">
                    {{ \Carbon\Carbon::parse($complaint['createdAt'])->translatedFormat('d F Y, H:i') }}
                </div>
            </div>
            
            @if($complaint['technician'])
                <div class="detail-section">
                    <div class="detail-label">Teknisi</div>
                    <div class="detail-value">👨‍🔧 {{ $complaint['technician'] }}</div>
                </div>
            @endif
            
            @if($complaint['notes'])
                <div class="detail-section">
                    <div class="detail-label">Catatan Teknisi</div>
                    <div class="detail-description">{{ $complaint['notes'] }}</div>
                </div>
            @endif
            
            @if($complaint['response'])
                <div class="response-section">
                    <div class="response-label">Respon</div>
                    <div class="response-value">{{ $complaint['response'] }}</div>
                    @if($complaint['responded_at'])
                        <div style="font-size: 12px; color: #6b7280; margin-top: 8px;">
                            {{ \Carbon\Carbon::parse($complaint['responded_at'])->translatedFormat('d F Y, H:i') }}
                        </div>
                    @endif
                </div>
            @endif
        </div>
    </div>
</body>
</html>