<?php $__env->startSection('title', 'Detail Pengajuan'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2>Detail Pengajuan Izin/Cuti</h2>
    <a href="<?php echo e(route('admin.complaints.index')); ?>" class="btn-secondary">← Kembali</a>
</div>

<div style="display:grid;grid-template-columns:2fr 1fr;gap:20px">
    <!-- Detail Pengajuan -->
    <div class="card">
        <h3 style="margin-bottom:16px">Informasi Pengajuan</h3>
        
        <div style="display:grid;gap:16px">
            <div>
                <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">Judul</label>
                <div style="font-size:16px;font-weight:600"><?php echo e($complaint->title); ?></div>
            </div>
            
            <div>
                <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">Kategori</label>
                <?php
                    $categoryBadge = [
                        'cuti' => ['bg' => '#dbeafe', 'text' => '#1e40af', 'icon' => '🏖️'],
                        'sakit' => ['bg' => '#fee2e2', 'text' => '#991b1b', 'icon' => '🤒'],
                        'izin' => ['bg' => '#fef3c7', 'text' => '#92400e', 'icon' => '📝'],
                        'lainnya' => ['bg' => '#f3f4f6', 'text' => '#374151', 'icon' => '💬'],
                    ];
                    $badge = $categoryBadge[$complaint->category] ?? $categoryBadge['lainnya'];
                ?>
                <span style="background:<?php echo e($badge['bg']); ?>;color:<?php echo e($badge['text']); ?>;padding:6px 12px;border-radius:6px;font-size:14px;font-weight:600">
                    <?php echo e($badge['icon']); ?> <?php echo e(ucfirst($complaint->category)); ?>

                </span>
            </div>
            
            <div>
                <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">Alasan</label>
                <div style="padding:12px;background:#f9fafb;border-radius:8px;white-space:pre-line"><?php echo e($complaint->description); ?></div>
            </div>

            <?php if($complaint->notes): ?>
            <div>
                <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">
                    📝 Catatan untuk Admin
                    <?php if($complaint->category == 'sakit'): ?>
                        <span style="color:#dc2626;font-weight:600">(Kondisi Medis)</span>
                    <?php endif; ?>
                </label>
                <div style="padding:12px;background:#fef3c7;border-left:4px solid #f59e0b;border-radius:8px;white-space:pre-line"><?php echo e($complaint->notes); ?></div>
            </div>
            <?php endif; ?>

            <?php if($complaint->attachment): ?>
            <div>
                <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">
                    📎 Lampiran
                    <?php if($complaint->category == 'sakit'): ?>
                        <span style="color:#dc2626;font-weight:600">(Surat MC/Dokter)</span>
                    <?php elseif($complaint->category == 'mendadak'): ?>
                        <span style="color:#f59e0b;font-weight:600">(Bukti Pendukung)</span>
                    <?php endif; ?>
                </label>
                <div style="padding:12px;background:#f0f9ff;border:1px solid #0ea5e9;border-radius:8px">
                    <?php
                        $extension = pathinfo($complaint->attachment, PATHINFO_EXTENSION);
                        $fileName = basename($complaint->attachment);
                        $isImage = in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif']);
                    ?>
                    
                    <?php if($isImage): ?>
                        <div style="margin-bottom:8px">
                            <img src="<?php echo e(asset('storage/' . $complaint->attachment)); ?>" 
                                 alt="Lampiran" 
                                 style="max-width:100%;height:auto;border-radius:6px;cursor:pointer"
                                 onclick="window.open('<?php echo e(asset('storage/' . $complaint->attachment)); ?>', '_blank')">
                        </div>
                    <?php endif; ?>
                    
                    <div style="display:flex;align-items:center;justify-content:space-between">
                        <div>
                            <strong><?php echo e($fileName); ?></strong><br>
                            <small style="color:#6b7280"><?php echo e(strtoupper($extension)); ?> • <?php echo e(number_format(Storage::size('public/' . $complaint->attachment) / 1024, 1)); ?> KB</small>
                        </div>
                        <a href="<?php echo e(asset('storage/' . $complaint->attachment)); ?>" 
                           target="_blank" 
                           style="background:#0ea5e9;color:white;padding:8px 12px;border-radius:6px;text-decoration:none;font-size:12px">
                            📂 Lihat File
                        </a>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
            <div>
                <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">Tanggal Pengajuan</label>
                <div><?php echo e($complaint->created_at->format('d F Y, H:i')); ?></div>
            </div>
            
            <?php if($complaint->response): ?>
                <div>
                    <label style="font-size:13px;color:#6b7280;display:block;margin-bottom:4px">Tanggapan Admin</label>
                    <div style="padding:12px;background:#f0f9ff;border-left:4px solid #0ea5e9;border-radius:8px">
                        <?php echo e($complaint->response); ?>

                    </div>
                    <?php if($complaint->responder): ?>
                        <small style="color:#6b7280;margin-top:4px;display:block">
                            Oleh: <?php echo e($complaint->responder->name); ?> • <?php echo e($complaint->responded_at->format('d F Y, H:i')); ?>

                        </small>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Sidebar -->
    <div>
        <!-- Status Card -->
        <div class="card" style="margin-bottom:16px">
            <h4 style="margin-bottom:12px;font-size:14px">Status</h4>
            <?php if($complaint->status == 'pending'): ?>
                <div style="background:#fef3c7;color:#92400e;padding:12px;border-radius:8px;text-align:center;font-weight:600">
                    ⏳ Menunggu Persetujuan
                </div>
            <?php elseif($complaint->status == 'approved'): ?>
                <div style="background:#d1fae5;color:#065f46;padding:12px;border-radius:8px;text-align:center;font-weight:600">
                    ✅ Disetujui
                </div>
            <?php else: ?>
                <div style="background:#fee2e2;color:#991b1b;padding:12px;border-radius:8px;text-align:center;font-weight:600">
                    ❌ Ditolak
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Karyawan Info -->
        <div class="card" style="margin-bottom:16px">
            <h4 style="margin-bottom:12px;font-size:14px">Informasi Karyawan</h4>
            <div style="display:grid;gap:8px">
                <div>
                    <small style="color:#6b7280">Nama</small>
                    <div style="font-weight:600"><?php echo e($complaint->user->name); ?></div>
                </div>
                <div>
                    <small style="color:#6b7280">Email</small>
                    <div><?php echo e($complaint->user->email); ?></div>
                </div>
                <?php if($complaint->user->phone): ?>
                    <div>
                        <small style="color:#6b7280">Telepon</small>
                        <div><?php echo e($complaint->user->phone); ?></div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Actions -->
        <?php if($complaint->status == 'pending'): ?>
            <div class="card">
                <h4 style="margin-bottom:12px;font-size:14px">Tindakan</h4>
                
                <!-- Approve Form -->
                <form method="POST" action="<?php echo e(route('admin.complaints.approve', $complaint->id)); ?>" style="margin-bottom:12px">
                    <?php echo csrf_field(); ?>
                    <textarea name="response" class="form-input" placeholder="Catatan persetujuan (opsional)" rows="3" style="margin-bottom:8px"></textarea>
                    <button type="submit" class="btn-primary" style="width:100%;background:#10b981" onclick="return confirm('Setujui pengajuan ini?')">
                        ✅ Setujui
                    </button>
                </form>
                
                <!-- Reject Form -->
                <form method="POST" action="<?php echo e(route('admin.complaints.reject', $complaint->id)); ?>">
                    <?php echo csrf_field(); ?>
                    <textarea name="response" class="form-input" placeholder="Alasan penolakan (wajib)" rows="3" style="margin-bottom:8px" required></textarea>
                    <button type="submit" class="btn-primary" style="width:100%;background:#ef4444" onclick="return confirm('Tolak pengajuan ini?')">
                        ❌ Tolak
                    </button>
                </form>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\absen-dutacom\resources\views/admin/complaints/show.blade.php ENDPATH**/ ?>